  (defun write-pdf (graph)
  (let* ((prev-file (set-file-dialog "Save pdf file" ))
        (file (strcat prev-file ".pdf"))
        )
 	(with-open-file (file file :direction :output)
		(let ((xrefs ())
			  (size (cddr (send graph :view-rect))))
			(format file "~A" pdf-header)
			(push (file-length file) xrefs)
			(dolist (obj (butlast pdf-objects))
				(format file "~A" obj)
				(push (file-length file) xrefs))
			(format file (car (last pdf-objects)) 0 -20 (first size) (+ 20 (second size)))
			(push (file-length file) xrefs)
			(let ((contents (make-pdf-string graph)))
				(format file (car pdf-stream) contents)
				(push (file-length file) xrefs)
				(format file (cadr pdf-stream) (length contents))
				(push (file-length file) xrefs))
			(apply #'format file pdf-trailer-template
				(reverse xrefs))))
(with-open-file (filename (strcat prev-file ".bat") :direction :output)
			(format filename 
"~A
erase ~A
exit"  (file-namestring file) (file-namestring (strcat prev-file ".bat"))))
(system (strcat prev-file ".bat")))) 